﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ComWatcher
{
    public partial class ComAddedMessage : Form
    {
        String msg;
        int timeout;

        public ComAddedMessage(String message,int timeout)
        {
            InitializeComponent();
            this.msg = message;
            this.timeout = timeout;
        }

        private void ComAddedMessage_Load(object sender, EventArgs e)
        {
            textBox1.Text = msg;
            Rectangle workingArea = Screen.GetWorkingArea(this);
            this.Location = new Point(workingArea.Right - Size.Width,
                                      workingArea.Bottom - Size.Height);
        }

        private void T_Tick(object sender, EventArgs e)
        {
            this.Hide();
            this.Close();
            this.Dispose();
        }

        private void ComAddedMessage_Shown(object sender, EventArgs e)
        {
            Timer t = new Timer();
            t.Interval = timeout;
            t.Tick += T_Tick;
            t.Start();
            this.BringToFront();
            this.Visible = true;
        }
    }
}
