﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ComWatcher.Properties;

namespace ComWatcher
{
    public partial class ComPorts : Form
    {
        DataTable source;
        /// <summary>
        /// The NotifyIcon object.
        /// </summary>
        /// 


        Boolean allowClose = false;

        ComSpy comspy;
        System.Windows.Forms.Timer comtimer;


        public ComPorts()
        {
            InitializeComponent();
            source = new DataTable();
            source.Columns.Add("Ports");
            Application.ApplicationExit += Application_ApplicationExit;
            SetupComSpy();
            SetupTimer();
        }


        private void SetupComSpy()
        {
            comspy = new ComSpy();
            comspy.PortAdded += new ComSpy.portadded(comspy_PortAdded);
            comspy.PortRemoved += new ComSpy.portremoved(comspy_PortRemoved);
        }

        private void SetupTimer()
        {
            if (comtimer != null)
            {
                comtimer.Stop();
                comtimer = null;
            }
            comtimer = new System.Windows.Forms.Timer();
            comtimer.Interval = 500;
            comtimer.Tick += new EventHandler(comtimer_Tick);
            comtimer.Start();
        }

        void comtimer_Tick(object sender, EventArgs e)
        {
            comspy.checkPorts();
        }


        /// <summary>
        /// Executed when the ports window is first loaded.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ComPorts_Load(object sender, EventArgs e)
        {
            Rectangle screen = System.Windows.Forms.Screen.PrimaryScreen.WorkingArea;
            this.Left = screen.Right - this.Width;
            this.Top = screen.Bottom - this.Height;

            RefreshList();
        }

        void comspy_PortRemoved(string name)
        {
            notifyIcon1.BalloonTipText = "Com Port Removed: " + name;
            notifyIcon1.ShowBalloonTip(5000);
            RefreshList();
            ComAddedMessage cam = new ComAddedMessage(notifyIcon1.BalloonTipText,5000);
            cam.Show();
        }

        void comspy_PortAdded(string name)
        {
            notifyIcon1.BalloonTipText = "New Com Port Detected: " + name;
            notifyIcon1.ShowBalloonTip(5000);
            RefreshList();
            ComAddedMessage cam = new ComAddedMessage(notifyIcon1.BalloonTipText,5000);
            cam.Show();

        }


        private void Application_ApplicationExit(object sender, EventArgs e)
        {
            // When the application closes, this will remove the icon from the system tray immediately.
            comtimer.Stop();
            notifyIcon1.Visible = false;
            notifyIcon1.Icon = null;
            notifyIcon1.Dispose();
            comspy.Dispose();
        }



        public void RefreshList()
        {
            if (dataGridView1.Columns.Count == 0)
                dataGridView1.Columns.Add(new DataGridViewColumn(new DataGridViewTextBoxCell()));

            dataGridView1.Columns[0].DataPropertyName = "Ports";
            dataGridView1.AutoGenerateColumns = false;
            dataGridView1.AllowUserToAddRows = false;
            dataGridView1.DataSource = source;
            source.Rows.Clear();

            foreach (ComSpy.PortInfo pi in ComSpy.ComPorts)
            {
                DataRow dr = source.NewRow();
                dr.ItemArray = new object[] { pi.name };
                source.Rows.Add(dr);
            }
            dataGridView1.Update();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            allowClose = true;
            Application.Exit();
        }

        private void refreshListToolStripMenuItem_Click(object sender, EventArgs e)
        {
            RefreshList();
        }

        private void notifyIcon1_BalloonTipClosed(object sender, EventArgs e)
        {
            var thisIcon = (NotifyIcon)sender;
            thisIcon.Visible = false;
            thisIcon.Dispose();
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            RefreshList();
            Show();
        }

        private void ComPorts_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.Visible = false;
            e.Cancel = !allowClose;
        }

        private void dataGridView1_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            int row = e.RowIndex;

            if (row < 0 || row > dataGridView1.Rows.Count - 1) { return; };

            String comport = (String)dataGridView1.Rows[row].Cells[0].Value;

            ListenerForm lf = new ListenerForm(comport);

            lf.Show();
        }
    }
}
