﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Management;
using System.IO.Ports;
using System.Threading;

namespace ComWatcher
{
    public class ComSpy : IDisposable
    {

        public static List<PortInfo> ComPorts;

        public delegate void portadded(string name);
        public delegate void portremoved(string name);
        public event portadded PortAdded;
        public event portremoved PortRemoved;

        public ComSpy()
        {
            if (ComPorts == null)
                ComPorts = new List<PortInfo>();
            else
                ComPorts.Clear();
        }

        private void AddPort(PortInfo pi, DateTime checkTime)
        {
            if (ComPorts == null)
                ComPorts = new List<PortInfo>();
            PortInfo thisPi = null;
            foreach (PortInfo cpi in ComPorts)
            {
                if (pi.name.Equals(cpi.name))
                {
                    thisPi = cpi;
                    break;
                }
            }

            if (thisPi == null)
            {
                ComPorts.Add(pi);
                if (PortAdded != null)
                    PortAdded(pi.name);
            }
            else
            {
                thisPi.lastSeen = checkTime;
            }
        }

        private void RemovePort(PortInfo pi)
        {
            if (ComPorts == null)
                ComPorts = new List<PortInfo>();

            PortInfo thisPi = null;
            foreach (PortInfo cpi in ComPorts)
            {
                if (pi.name.Equals(cpi.name))
                {
                    thisPi = cpi;
                    break;
                }
            }
            if (thisPi != null)
            {
                ComPorts.Remove(pi);
                if (PortRemoved != null)
                    PortRemoved(pi.name);
            }
        }

        public void checkPorts()
        {
            DateTime checkTime = DateTime.Now;
            string[] portnames = SerialPort.GetPortNames();

            foreach (string port in portnames)
            {
                AddPort(new PortInfo(port), checkTime);
            }

            for (int i = ComPorts.Count - 1; i >= 0; i--)
            {
                if (ComPorts[i].lastSeen != checkTime)
                {
                    RemovePort(ComPorts[i]);
                }
            }

        }

        public void Dispose()
        {
            if (ComPorts != null)
            {
                ComPorts.Clear();
                ComPorts = null;
            }
        }


    public class PortInfo
    {
        public String name;
        public DateTime lastSeen;


        public PortInfo(String name)
        {
            this.name = name;
            lastSeen = DateTime.Now;
        }
    }

    }

}