﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace ComWatcher
{
    public partial class ListenerForm : Form
    {
        String portName;
        SerialPort port;
        PortListener pl;

        public ListenerForm(String portName)
        {
            InitializeComponent();
            this.portName = portName;
            this.pl = null;
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (port != null && port.IsOpen)
            {
                port.Close();
            }
            Application.Exit();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            EnumerateComPorts();
            txtPortName.Text = portName;
            txtBaudRate.Text = "9600";
            cbBits.SelectedIndex = 0;
            cbFlowControl.SelectedIndex = 0;
            cbParity.SelectedIndex = 0;
            cbStopBits.SelectedIndex = 0;
            dataGridView1.FirstDisplayedScrollingRowIndex = dataGridView1.RowCount - 1;
            txtRowCount.Validating += TxtRowCount_Validating;
        }

        private void TxtRowCount_Validating(object sender, CancelEventArgs e)
        {
            short result;
            bool b = Int16.TryParse(txtRowCount.Text, out result);

            if (result < 1 || result > 1000 || b == false)
            {
                MessageBox.Show("Only Valid numbers between 1 and 1000 please.");
                e.Cancel = true; 
            }
        }

        private void EnumerateComPorts()
        {
            string[] ports = SerialPort.GetPortNames();

        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            AddRow("== Connected ==");
            if (this.pl != null)
            {
                pl.Stop();
                pl = null;
            }
            pl = new PortListener(txtPortName.Text, Int32.Parse(txtBaudRate.Text), cbParity.SelectedItem.ToString(), cbBits.SelectedItem.ToString(), cbStopBits.SelectedItem.ToString(), cbFlowControl.SelectedItem.ToString());
            pl.ErrorOccurred += new PortListener.ErrorDelegate(pl_ErrorOccurred);
            pl.MessageRecieved += new PortListener.MessageRecievedDelegate(pl_MessageRecieved);
            pl.PortDisposed += Pl_PortDisposed;
            pl.Execute();
        }

        private void Pl_PortDisposed(PortInfo info, string Error)
        {
            AddRow("DISCONNECTION: " + Error);
        }

        void pl_MessageRecieved(PortInfo info, string message)
        {
            AddRow(message);

        }

        void pl_ErrorOccurred(PortInfo info, string Error)
        {
            AddRow("Error " + Error);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.pl != null)
            {
                pl.Stop();
                pl = null;
            }
        }

        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            AddRow("== Manually Disconnected ==");
           
            if (this.pl != null)
            {
                pl.Stop();
                pl = null;
            }

        }


        private void AddRow(String message)
        {


            short rowcount = 100;
            if (!Int16.TryParse(txtRowCount.Text, out rowcount))
            {
                rowcount = 100;
            }

            if (this.InvokeRequired)
            {
                dataGridView1.Invoke(new Action(() =>
                {
                    dataGridView1.Rows.Add(DateTime.Now, message);
                    if (cbAutoScroll.Checked)
                    {
                        dataGridView1.FirstDisplayedScrollingRowIndex = dataGridView1.RowCount - 1;
                    }

                    while (dataGridView1.RowCount > 0 && dataGridView1.RowCount > rowcount)
                    {
                        dataGridView1.Rows.RemoveAt(0);
                    }

                }));
            }
            else
            {
                dataGridView1.Rows.Add(DateTime.Now, message);
                if (cbAutoScroll.Checked)
                {
                    dataGridView1.FirstDisplayedScrollingRowIndex = dataGridView1.RowCount - 1;
                }

                while (dataGridView1.RowCount > 0 && dataGridView1.RowCount > rowcount)
                {
                    dataGridView1.Rows.RemoveAt(0);
                }

            }



        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            dataGridView1.Rows.Clear();
        }

        private void cbAutoScroll_CheckedChanged(object sender, EventArgs e)
        {
            if (cbAutoScroll.Checked)
            {
                dataGridView1.FirstDisplayedScrollingRowIndex = dataGridView1.RowCount - 1;
            }
            else
            {
                dataGridView1.FirstDisplayedScrollingRowIndex = 0;
            }
        }

        private void txtRowCount_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r' || e.KeyChar == '\n')
            {
                short result;
                bool b = Int16.TryParse(txtRowCount.Text, out result);

                if (result < 1 || result > 1000 || b == false)
                {
                    MessageBox.Show("Only Valid numbers between 1 and 1000 please.");
                    txtRowCount.Text = "100";
                }
            }

        }

        private void txtRowCount_TextChanged(object sender, EventArgs e)
        {
        }
    }
}
