﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.IO.Ports;

namespace ComWatcher
{
    class PortInfo
    {
        public String   portname;
        public DateTime started;
        public DateTime firstmessage;
        public DateTime lastmessage;


    }

    class PortListener 
    {
        DateTime started;
        DateTime firstmessage;
        DateTime lastmessage;
        String PortName;
        Boolean State;
        SerialPort thePort;

        public delegate void MessageRecievedDelegate(PortInfo info, String message);
        public delegate void ErrorDelegate(PortInfo info, String Error);

        public event MessageRecievedDelegate MessageRecieved;
        public event ErrorDelegate ErrorOccurred;
        public event ErrorDelegate PortDisposed;

        private void OnErrorOccurred(String Message)
        {
            if (ErrorOccurred != null)
            {
                PortInfo info = new PortInfo();
                info.firstmessage = firstmessage;
                info.lastmessage = lastmessage;
                info.portname = PortName;
                info.started = started;
                ErrorOccurred(info, Message);

            }
        }

        private void OnPortDisposed(String Message)
        {
            if (PortDisposed!= null)
            {
                PortInfo info = new PortInfo();
                info.firstmessage = firstmessage;
                info.lastmessage = lastmessage;
                info.portname = PortName;
                info.started = started;
                PortDisposed(info, Message);
            }
        }

        private void OnMessageRecieved(String Message)
        {

            if (MessageRecieved != null)
            {
                PortInfo info = new PortInfo();
                info.firstmessage = firstmessage;
                info.lastmessage = lastmessage;
                info.portname = PortName;
                info.started = started;
                MessageRecieved(info, Message);
            }
        }




        public PortListener(String Port, int baudRate, string Parity, String Bits, String StBits, String FlowControl)
        {
            Parity parity = new System.IO.Ports.Parity();
            StopBits stopbits = new StopBits();
            State = false;
            try
            {
                parity = (Parity)Enum.Parse(parity.GetType(), Parity);
                stopbits = (StopBits)Enum.Parse(stopbits.GetType(), StBits);
            }
            catch (Exception ex)
            {
                throw new Exception("Unable to parse some of the port settings " + ex.Message);
            }

            try
            {
                thePort = new SerialPort(Port, baudRate, parity, Int32.Parse(Bits), stopbits);
                thePort.ErrorReceived += ThePort_ErrorReceived;
                thePort.DataReceived += ThePort_DataReceived;
                thePort.Disposed += ThePort_Disposed;
            }
            catch (Exception ex)
            {
                throw new Exception("Unable to open the port because :" + ex.Message);
            }
        }

        private void ThePort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            SerialPort p = (SerialPort)sender;
            if (!p.IsOpen) { return; }

            int bytes = p.BytesToRead;
            byte[] buffer = new byte[bytes];
            p.Read(buffer, 0, bytes);

            String str = System.Text.Encoding.Default.GetString(buffer);

            OnMessageRecieved(str);
        }

        private void ThePort_ErrorReceived(object sender, SerialErrorReceivedEventArgs e)
        {
            OnErrorOccurred(e.EventType.ToString());
        }

        private void ThePort_Disposed(object sender, EventArgs e)
        {
            OnPortDisposed(" *port disposed or forcibly closed* ");
        }


        public void Execute()
        {
            if (State == true)
            {
                throw new Exception("Sniffer already running");
            }
            if (thePort.IsOpen)
            {
                throw new Exception("Port is already open. Close it first.");
            }

            try
            {
                thePort.Open();
            }
            catch (Exception ex)
            {
                throw new Exception("Unable to open the port because :" + ex.Message);
            }

        }

        public void Stop()
        {
            if (thePort != null)
            {
                try {
                    thePort.Close();
                }
            catch (Exception) { }

                thePort = null;
            }

        }

    }
}
