﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using WMPLib;

namespace DBMTerm
{

    public partial class DBMTerm : Form
    {
        CommsHelper commHandler;
        ToolStripMenuItem lastRun = null;

        Boolean isLoaded = false;
        Boolean isConnected = false;

        public DBMTerm()
        {
            commHandler = new CommsHelper();
            commHandler.OnData += new CommsHelper.ErrorEventHandler(commHandler_OnData);
            commHandler.OnInfo += new CommsHelper.ErrorEventHandler(commHandler_OnInfo);
            commHandler.OnError += new CommsHelper.ErrorEventHandler(executor_OnError);
            commHandler.PortAdded += new CommsHelper.PortAddedHandler(commHandler_PortAdded);
            commHandler.PortRemoved += new CommsHelper.PortAddedHandler(commHandler_PortRemoved);
            commHandler.PortConnected += new CommsHelper.PortAddedHandler(commHandler_PortConnected);
            commHandler.PortDisconnected += new CommsHelper.PortAddedHandler(commHandler_PortDisconnected);
            commHandler.PortBaudRateChanged += new CommsHelper.ValueChangedHandler(commHandler_PortBaudRateChanged);
            InitializeComponent();
        }

        Boolean baudJustChanged = false;
        void commHandler_PortBaudRateChanged(int value)
        {
            baudJustChanged = true;
            for (int i = 0 ; i < lstBaud.Items.Count ; i++)
            {
                String s = lstBaud.Items[i] as String;
                if (s.Equals(value.ToString()))
                    lstBaud.SelectedIndex = i;
            }
        }



        void commHandler_OnData(string Text)
        {
            if (!(Text.Equals("Error on Port:Frame") && baudJustChanged == false))
            {
                txtRcv.Invoke(new Action(() => { txtRcv.AppendText(Text); txtRcv.Invalidate(); Application.DoEvents(); }));
            }
            baudJustChanged = false;
        }


        void commHandler_OnInfo(string Text)
        {
            txtRcv.Invoke(new Action(() => { txtRcv.AppendText(Text); txtRcv.Invalidate(); Application.DoEvents(); }));
        }

        void  commHandler_PortDisconnected(string portName)
        {
            isConnected = false;

            txtRcv.Invoke(new Action(() => 
            { 
                txtRcv.AppendText("Disconnected from " + portName+"\r\n"); 

                foreach (ListViewItem lvi in lstports.Items)
                {
                    if (lvi.Text.Equals(portName, StringComparison.CurrentCultureIgnoreCase))
                    {
                        lvi.ImageIndex = 0;
                        lvi.BackColor = Color.White;
                    }
                }
                btnConnect.BackgroundImage = Properties.Resources.connect;
                btnReRun.BackgroundImage = Properties.Resources.rerun_disabled;
                btnReRun.Enabled = false;
                btnConnect.Enabled = true;
            

            
            }));


        }

        void commHandler_PortConnected(String portName)
        {
            isConnected = true;

            txtRcv.Invoke(new Action(() =>
            {
                btnConnect.BackgroundImage = Properties.Resources.disconnect;
                btnConnect.Enabled = true;

                btnReRun.BackgroundImage = Properties.Resources.rerun;
                btnReRun.Enabled = true;

                foreach (ListViewItem lvi in lstports.Items)
                {
                    if (lvi.Text.Equals(portName, StringComparison.CurrentCultureIgnoreCase))
                        lvi.ImageIndex = 1;
                }

                txtRcv.AppendText("Connected "+portName+" @ [" + this.commHandler.currentPort.BaudRate.ToString() + "/" + this.commHandler.currentPort.DataBits.ToString() + "/" + this.commHandler.currentPort.StopBits.ToString() + "/" + this.commHandler.currentPort.Parity.ToString() + "/" + this.commHandler.currentPort.Handshake.ToString() + "]\r\n");

            }));
        }


        void commHandler_PortRemoved(string portName)
        {
            if (isConnected)
            {
                commHandler.Disconnect();
            }

            lstports.Invoke(new Action(() =>
            {
                foreach (object i in lstports.Items)
                {
                    if (((ListViewItem)i).Text.Equals(portName, StringComparison.CurrentCultureIgnoreCase))
                    {
                        lstports.Items.Remove((ListViewItem)i);
                    }
                }
            }
            ));
        }

        void commHandler_PortAdded(string portName)
        {
            ListViewItem lvi = null;
            Boolean bFound = false;
            lstports.Invoke(new Action(() =>
            {

                    foreach (object i in lstports.Items)
            {
                if (((ListViewItem)i).Text.Equals(portName, StringComparison.CurrentCultureIgnoreCase))
                {
                    lvi = (ListViewItem)i;
                    bFound = true;
                }
            }
            if (!bFound)
            {
                lvi = new ListViewItem(portName);
                lvi.ImageIndex = 0;
                    lstports.Items.Add(lvi);
                    lstports.Sort();
            }
         
            if (commHandler.ScriptRunning == true && portName.Equals(commHandler.currentPort.PortName))
            {
                foreach (ListViewItem lvi2 in lstports.Items)
                {
                    if (lvi2.Text.Equals(portName))
                        lvi2.Selected = true;
                }
                System.Threading.Thread.Sleep(500);
                btnConnect_Click(null, null);
            }

            }));
        }

        #region Callbacks
        /// <summary>
        /// Script Executor callback.
        /// </summary>
        /// <param name="errorText"></param>
        void executor_OnError(string errorText)
        {
            txtRcv.Invoke(new Action(() => { txtRcv.AppendText(errorText); }));
        }

        #endregion


        #region UI Callbacks
        private void DBMTerm_Load(object sender, EventArgs e)
        {
            lstBaud.SelectedIndex = 2;
            lstBits.SelectedIndex = 1;
            lstParity.SelectedIndex = 0;
            lstStopBits.SelectedIndex = 0;
            lstFlowControl.SelectedIndex = 0;
            prev_selectedindex_baud = lstBaud.SelectedIndex;
            prev_selectedindex_parity = lstParity.SelectedIndex;
            prev_selectedindex_bits = lstBits.SelectedIndex;
            prev_selectedindex_stopbits = lstStopBits.SelectedIndex;
            prev_selectedindex_flowcontrol = lstFlowControl.SelectedIndex;
            Bitmap sp = GetImageByName("serialport");
            Bitmap spc = GetImageByName("serialport_closed");
            lstports.SmallImageList = new ImageList();
            lstports.LargeImageList = new ImageList();
            lstports.SmallImageList.Images.Add(spc);
            lstports.SmallImageList.Images.Add(sp);
            lstports.LargeImageList.Images.Add(spc);
            lstports.LargeImageList.Images.Add(sp);
          
            this.commHandler.DetectPorts();
            if (lstports.Items.Count > 0)
            {
                lstports.Items[0].Selected = true;
                lstports.Select();
            }

            backgroundWorker1.RunWorkerAsync();
            isLoaded = true;
        }

        
        private void quitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            backgroundWorker1.CancelAsync();

            Application.Exit();
        }

        #endregion

        #region Port Stuff
        #endregion
        public  Bitmap GetImageByName(string imageName)
        {
            System.Reflection.Assembly asm = System.Reflection.Assembly.GetExecutingAssembly();
            string resourceName = asm.GetName().Name + ".Properties.Resources";
            var rm = new System.Resources.ResourceManager(resourceName, asm);
            return (Bitmap)rm.GetObject(imageName);

        }







        void Insert(int loc, String data) 
        { 
            // Make the newlines PC compliant.
            char[] dstring = data.ToCharArray();

            if (dstring.Contains<char>('\f'))
                for (int i = 0; i < dstring.Length; i++)
                {
                    if (dstring[i] == '\f') { dstring[i] = '\r'; }
                    if (dstring[i] == '\r') { dstring[i] = '\n'; }
                }

            String xs = new String(dstring);
            txtRcv.SelectedText = xs;
        }





        private void lstports_SelectedIndexChanged(object sender, EventArgs e)
        {
            // What is the selected port?
            String selport = null;

            // Are we right now connected to a port?
            Boolean isConnected = false;

            // is the selected port, the currently connected port?
            Boolean currportselected = false;

            // get the currently selected portname.
            if (lstports.SelectedItems.Count > 0)
                selport = ((ListViewItem)lstports.SelectedItems[0]).Text;

            // Get the current state of the port etc
            if (commHandler.currentPort != null)
            {
                if (commHandler.currentPort.IsOpen)
                {
                    isConnected = true;
                }
                if (selport != null && commHandler.currentPort.PortName.Equals(selport))
                {
                    currportselected = true;
                }
            }

            // No button is currently selected, but we are currently
            // connected, so set the connect state to disconnect.
            if (isConnected == true)
            {
                btnConnect.Enabled = true;
                btnConnect.BackgroundImage = Properties.Resources.disconnect;
            }
            else
            {
                if (selport == null)  // discon & no port selected.
                {
                    btnConnect.Enabled = false;
                    btnConnect.BackgroundImage = Properties.Resources.disabled_connect;
                }
                else
                {
                    btnConnect.Enabled = true;
                    btnConnect.BackgroundImage = Properties.Resources.connect;
                }
            }
        }

        private Boolean Connect(String s)
        {
            if (!Connect())
            {
                txtRcv.AppendText("Operation Failed. \r\n");
                return false;
            }
           // txtRcv.AppendText(s + "\r\n");
            return true;
        }

        /// <summary>
        /// Quick connect by scraping off the UI
        /// </summary>
        Boolean _connecting = false;
        private Boolean Connect()
        {
            if (_connecting == true)
            {
                txtRcv.AppendText("Already connecting...");
                return false;
            }

            _connecting = true;
            try
            {
                if (lstports.SelectedItems.Count > 0)
                {
                    ListViewItem lvi = lstports.SelectedItems[0];

                    if (!commHandler.Connect(
                        lvi.Text,
                        lstBaud.SelectedItem.ToString(),
                        lstBits.SelectedItem.ToString(),
                        lstStopBits.SelectedItem.ToString(),
                        lstParity.SelectedItem.ToString()
                        ))
                        throw new Exception("Failed to connect.");

                    txtRcv.Focus();
                }
                // success!!!!
                _connecting = false;
                btnConnect.BackgroundImage = Properties.Resources.disconnect;
            }
            catch(Exception ex)
            {
                _connecting = false;
                MessageBox.Show("Unable to connect: " + ex.Message);
                btnConnect.BackgroundImage = Properties.Resources.connect;
                btnReRun.BackgroundImage = Properties.Resources.rerun_disabled;
                btnReRun.Enabled = false;
                btnConnect.Enabled = true;
                return false;
            }


            return true;
        }


        private void txtRcv_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                if (this.commHandler.currentPort == null || this.commHandler.currentPort.IsOpen == false)
                {
                    txtRcv.AppendText("\r\nPort Not connected.");
                }
                else
                {
                    TextBox tb = (TextBox)sender;
                    int iEnd = tb.SelectionStart;
                    int iLineStart = tb.GetFirstCharIndexOfCurrentLine();
                    String textToSend = tb.Text.Substring(iLineStart, tb.SelectionStart - iLineStart) + "\r\n";
                    tb.Text = tb.Text.Substring(0, tb.SelectionStart);
                    tb.SelectionStart = tb.Text.Length;
                    List<String> s = new List<string>();
                    s.Add(textToSend);
                    commHandler.Execute(s, false);
 
                }
            }
        }


        private bool ReportError(String message)
        {

            MessageBox.Show(message);
            return true;
        }

        // local versions
        public bool Execute(List<String> commands, Boolean showCommand)
        {
            
            if (commHandler.currentPort == null || commHandler.currentPort.IsOpen == false)
                return false;

            commHandler.Execute(commands, showCommand);
            
            axWMP1.Ctlcontrols.play();
 
            return true;
        }


        private void Execute(String filename)
        {
            if (!System.IO.File.Exists(filename))
            {
                ReportError("File does not exist");
                return;
            }
            String[] contents = System.IO.File.ReadAllLines(filename);
            
            commHandler.Execute(contents.ToList(),true);
        }
         


        private void txtRcv_TextChanged(object sender, EventArgs e)
        {
            //if (txtRcv.TextLength > 500 && txtRcv.SelectionStart > 200)
            //{
            //    txtRcv.Text = txtRcv.Text.Substring(txtRcv.TextLength - 500);
            //    txtRcv.SelectionStart = txtRcv.TextLength - 1;
            //    txtRcv.ScrollToCaret();
            //}        
        }


        private void buildScriptToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ScriptBuilderForm sbf = new ScriptBuilderForm(this);
            sbf.Show();
        }


        private void userScriptToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Script|*.txt|(All Files)|*.*";
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                String[] filelines = new String[1];
                try
                {
                    filelines = System.IO.File.ReadAllLines(ofd.FileName);

                    int lastSlash = ofd.FileName.LastIndexOf('\\')+1;
                    if (lastSlash < 0)
                        lastSlash = 0;
                    ToolStripMenuItem mi = new ToolStripMenuItem(ofd.FileName.Substring(lastSlash));
                    mi.Tag = ofd.FileName;
                    executeToolStripMenuItem1.DropDownItems.Add(mi);
                    mi.Click += new EventHandler(mi_Click);
                    executeToolStripMenuItem1.Invalidate();
                    lastRun = mi;
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Problem loading file " + ex.Message);
                    return;
                }

                try
                {
                    commHandler.Execute(filelines.ToList<String>(), true);
                  
                    btnReRun.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }

            }
        }

        void mi_Click(object sender, EventArgs e)
        {
            DialogResult r = MessageBox.Show("Prompt For Variables?", "Re-prompt?", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            if (r == System.Windows.Forms.DialogResult.Cancel)
                return;

            if (r == System.Windows.Forms.DialogResult.No)
                commHandler.PromptForVars = false;
            try
            {
                lastRun = (ToolStripMenuItem)sender;
                this.Execute((String)((ToolStripMenuItem)sender).Tag);
                btnReRun.Enabled = true;

            }
            catch (Exception ex)
            {
                MessageBox.Show("Error executing Script: " +ex.Message);
            }

            commHandler.PromptForVars = true;

        }

   

        private void btnScan_Click(object sender, EventArgs e)
        {
            this.commHandler.DetectPorts();
        }

        Boolean _inhibit = false;
        int prev_selectedindex_baud = 0;
        int prev_selectedindex_parity = 0;
        int prev_selectedindex_bits = 0;
        int prev_selectedindex_stopbits = 0;
        int prev_selectedindex_flowcontrol = 0;

        private void do_SelChange(String connectText, ListBox listBox, ref int prev_index)
        {

            if (_inhibit)
                return; 
            
            int index = listBox.SelectedIndex;
        

            if (this.isLoaded && commHandler.currentPort != null)
            {
                if (!Connect(connectText + " " + listBox.SelectedItem.ToString()))
                {
                    _inhibit = true;
                    listBox.SelectedIndex = prev_index;
                    _inhibit = false;
                }
                else
                {
                    prev_index = index;
                    _inhibit = true;
                    listBox.SelectedIndex = index;
                    _inhibit = false;
                }
            }
        }




        private void lstBaud_SelectedIndexChanged(object sender, EventArgs e)
        {
            do_SelChange("Baud rate changed to", (ListBox)sender, ref prev_selectedindex_baud);
        }

        private void lstParity_SelectedIndexChanged(object sender, EventArgs e)
        {
            do_SelChange("Parity changed to", (ListBox)sender, ref prev_selectedindex_parity);
        }

        private void lstBits_SelectedIndexChanged(object sender, EventArgs e)
        {
            do_SelChange("Bits changed to", (ListBox)sender, ref prev_selectedindex_bits);
        }

        private void lstStopBits_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (lstStopBits.SelectedItem.Equals("0"))
            {
                if (MessageBox.Show("It is HIGHLY unlikely that your hardware supports zero stop bits. Are you sure?", "Zero Stop Bits", MessageBoxButtons.YesNo) == System.Windows.Forms.DialogResult.No)
                {
                    lstStopBits.SelectedIndex = prev_selectedindex_stopbits;
                    return;
                }
            }
            do_SelChange("Stop Bits changed to", (ListBox)sender, ref prev_selectedindex_stopbits);
        }

        private void lstFlowControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            do_SelChange("Flow Control changed to", (ListBox)sender, ref prev_selectedindex_flowcontrol);
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
           BackgroundWorker worker = sender as BackgroundWorker;

            while(true)
            {

                if ((worker.CancellationPending == true))
                {
                    e.Cancel = true;
                    break;
                }
                else
                {
                    // If a script is running, don't bother detecting new ports!
                    // It'll just piss off the script runner.. Keep sleeping!
                    if (!commHandler.ScriptRunning)
                    {
                        commHandler.DetectPorts();
                        System.Threading.Thread.Sleep(1000);
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(5000);
                    }
                }
            }
        }

        private void DBMTerm_FormClosing(object sender, FormClosingEventArgs e)
        {
            backgroundWorker1.CancelAsync();
        }

        private void sendFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                try
                {
                    List<String> commands = new List<String>();
                    commands.Add("#Sending File " + ofd.FileName);
                    commands.Add("$SEND " + ofd.FileName);
                    commHandler.Execute(commands, true);

                }
                catch (Exception ex)
                {
                    MessageBox.Show("Error processing file: " + ex.Message);
                }

            }
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            if (commHandler.currentPort == null || commHandler.currentPort.IsOpen == false)
            {
                try
                {
                    Connect();
                }
                catch (Exception ex)
                {
                    if (commHandler != null)
                        commHandler.Disconnect();
                    MessageBox.Show("Problem Connecting :" + ex.Message);
                    btnConnect.BackgroundImage = Properties.Resources.connect;
                }
            }
            else
            {
                commHandler.Disconnect();
                btnConnect.BackgroundImage = Properties.Resources.connect;

            }
        }

        private void lstports_Leave(object sender, EventArgs e)
        {
            if (lstports.SelectedItems.Count > 0)
                lstports.SelectedItems[0].BackColor = SystemColors.ControlLight;
        }

        private void lstports_Enter(object sender, EventArgs e)
        {
            if (lstports.SelectedItems.Count > 0)
                lstports.SelectedItems[0].BackColor = SystemColors.Window;

        }

        private void btnReRun_Click(object sender, EventArgs e)
        {
            commHandler.PromptForVars = false;

            try
            {
                this.Execute((String)((ToolStripMenuItem)lastRun).Tag);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error executing Script: " + ex.Message);
            }

            commHandler.PromptForVars = true;

        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {

        }

        private void transferToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void scriptEndSoundToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "MP3 Files|*.mp3|WAV Viles|*.wav|All Files|*.*";
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                axWMP1.URL = ofd.FileName;
                axWMP1.Ctlcontrols.play();
                MessageBox.Show("Stop Playing");
                axWMP1.Ctlcontrols.stop();
            }

        }

        private void sendFileToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            List<string> cmds = new List<string>();

            if (commHandler == null || commHandler.currentPort == null)
            {
                MessageBox.Show("Not Connected");
                return;
            }

//            cmds.Add("$SET BAUD=AUTO");
            cmds.Add("$PROMPT @tmp_fn");
            cmds.Add("$SEND @tmp_fn");

            commHandler.Execute(cmds, false);
        }

        private void txtRcv_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && (e.KeyCode == Keys.A))
            {
                if (sender != null)
                    ((TextBox)sender).SelectAll();
                e.Handled = true;
            }
        }

        private void executeToolStripMenuItem1_Click(object sender, EventArgs e)
        {

        }
        

       

    }
}
