﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DBMTerm
{
    public partial class ScriptBuilderForm : Form
    {
        DBMTerm parent;
        public ScriptBuilderForm(DBMTerm mainForm)
        {
            parent = mainForm;
            InitializeComponent();
        }

        private void ScriptBuilderForm_Load(object sender, EventArgs e)
        {
            if (!System.IO.File.Exists("./help.htm"))
                webBrowser1.Navigate(new Uri(@"http://www.inetdaemon.com/tutorials/computers/hardware/modems/at_commands.shtml"));
            else
            {
                webBrowser1.DocumentText = String.Join("", System.IO.File.ReadAllLines("help.htm"));
                webBrowser1.Refresh();
            }

            textBox1.Text = textBox1.Text.Replace("<DATE>", DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToShortTimeString());
            
        }


        private void loadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Text Files (*.txt)|*.txt|Script Files (*.scr)|*.scr|All Files (*.*)|*.*";
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                String[] filelines = new String[1];
                try
                {
                    filelines = System.IO.File.ReadAllLines(ofd.FileName);
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Problem loading file " + ex.Message);
                }
                textBox1.Text = String.Join("\r\n", filelines);
            }
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveFileDialog ofd = new SaveFileDialog();
            ofd.Filter = "Text Files (*.txt)|*.txt|Script Files (*.scr)|*.scr|All Files (*.*)|*.*";
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {

                try
                {
                    System.IO.File.WriteAllText(ofd.FileName, textBox1.Text);
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Problem writing file " + ex.Message);
                }
            }
        }

        private void closeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void executeToolStripMenuItem_Click(object sender, EventArgs e)
        { 
            
            string [] lines = textBox1.Text.Split(new string[]{"\r\n"},StringSplitOptions.RemoveEmptyEntries);
            for (int i = 0; i < lines.Length; i++)
                lines[i] = lines[i] + "\r\n";
            List<String> lineslist = lines.ToList();
            lineslist.Insert(0, "$PRINT Executing Script...");
            if (!parent.Execute(lineslist, true))
            {
                MessageBox.Show("Unable to execute.  Ensure the port is connected.");
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
           
        }

        private void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control == true && e.KeyCode == Keys.A)
            {
                textBox1.SelectAll();
            }
        }

        private void textBox1_DragDrop(object sender, DragEventArgs e)
        {
            String s = "help";
            Boolean filedata = e.Data.GetDataPresent(DataFormats.FileDrop);
            Boolean textdata = e.Data.GetDataPresent(DataFormats.Text);

            if (filedata == true)
            {
                string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
                if (files.Length >= 1)
                {
                    try
                    {
                        String data = System.IO.File.ReadAllText(files[0]);
                        if (DialogResult.Yes == MessageBox.Show("Replace all lines with file?", "", MessageBoxButtons.YesNo))
                            textBox1.Text = data;

                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show("Unable to add data from " + files[0] + "\r\n"+ex.Message);
                        return;
                    }
                }
            }
            else if (textdata == true)
            {
                Point p = new Point(e.X, e.Y);
                Point cp = textBox1.PointToClient(p);

                int ci = textBox1.GetCharIndexFromPosition(cp);
                String datalines = (string)e.Data.GetData(DataFormats.Text);
                textBox1.Text = textBox1.Text.Insert(ci, datalines);
                textBox1.Refresh();
            }
        }

        private void textBox1_DragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop) || e.Data.GetDataPresent(DataFormats.Text))
                e.Effect = DragDropEffects.Copy;
            else
                e.Effect = DragDropEffects.None;
        }
    }
}
