﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DBMTerm
{
    public partial class VariablePromptForm : Form
    {
        String varname;

        public VariablePromptForm(String variablename)
        {
            varname = variablename.Trim();
            InitializeComponent();
        }

        private void VariablePromptForm_Load(object sender, EventArgs e)
        {
            label1.Text = varname;
        }

        private void btnFindFile_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                textBox1.Text = ofd.FileName;
        }

        public Variable getVariable()
        {
            Variable v = new Variable(varname, textBox1.Text);
            return v;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            this.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.Close();
        }

        private void btnAbort_Click(object sender, EventArgs e)
        {
            this.DialogResult = System.Windows.Forms.DialogResult.Abort;
            this.Close();
        }
    }
}
