﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DBMTerm
{
    public class Variable
    {
        public String name;
        public String value;

        public Variable(String _name, String _value)
        {
            name = _name;
            value = _value;
        }

        public Variable(String varline)
        {
            string[] parts = varline.Split(new char[] { '=' }, StringSplitOptions.RemoveEmptyEntries);

        }
                 
    }

    class VariableList
    {
        public List<Variable> list;

        public VariableList()
        {
            list = new List<Variable>();
        }


        // Get a variable, ensuring to interpolate its value.
        public Variable Get(String name)
        {
            foreach(Variable v in list)
            {
                if (v.name.Equals(name, StringComparison.CurrentCultureIgnoreCase))
                {
                    Variable tmpVar = new Variable(v.name, Interpolate(v.value));
                    return tmpVar;
                }
            }
            return null;
        }


        public String Interpolate(String input)
        {
            String output = input;

            // Let the variables chain up to 4 times.
            for (int i = 0; i < 3; i++)
            {
                foreach (Variable v in list)
                {
                    output = output.Replace(v.name, v.value);
                }
            }

            return output;
        }


        public void Set(String name, String value)
        {
           // Variable v = Get(name);
            Boolean found = false;

            foreach (Variable v in list)
            {
                if (v.name.Equals(name,StringComparison.CurrentCultureIgnoreCase))
                {
                    v.value = value;
                    found = true;
                }
            }

            if (!found)
                list.Add(new Variable(name, value));
        }
       
    }
}
