﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace MetaYAMLer
{
    public partial class MainForm : Form
    {
        String foldername;
        List<String> files;
        int offset = 0;
        Boolean change = false;


        public MainForm()
        {
            files = new List<string>();
            InitializeComponent();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            syncText();
            Application.Exit();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            syncText();
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            if (!String.IsNullOrEmpty(textBox3.Text))
                fbd.SelectedPath = textBox3.Text;

            if (fbd.ShowDialog() == DialogResult.OK)
            {
                foldername = fbd.SelectedPath;
                openFolder(foldername);
            }
        }


        private void refresh()
        {
            if (files.Count() == 0)
                return;

            String thisFile = files[offset];
            String filename = Path.Combine(foldername, thisFile);
            this.Text = thisFile;
            try
            {
                Image image = Image.FromFile(filename);
                pictureBox1.Image = image;
                pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;
            }
            catch (Exception)
            {
                pictureBox1.Image = null;
            }

            filename = Path.Combine(foldername, thisFile) + ".meta.yaml";
            textBox1.Text = "";
            textBox2.Text = "";
            if (File.Exists(filename))
            {
                List<String> lines = File.ReadAllLines(filename).ToList();
                foreach (String line in lines)
                {
                    List<String> parts = line.Split(new char[] { ':' }).ToList();
                    if (parts[0].Equals("alt_text",StringComparison.CurrentCultureIgnoreCase))
                    {
                        textBox1.Text = parts[1].TrimStart(new char[] { ' ' });
                    }
                    else if (parts[0].Equals("description", StringComparison.CurrentCultureIgnoreCase))
                    {
                        textBox2.Text = parts[1].TrimStart(new char[] { ' ' }).Replace("<br>","\r\n");
                    }
                }
            }
            change = false;
        }

        private void syncText()
        {
            if (files.Count() == 0)
                return;
            if (!change)
                return;
            

            String thisFile = files[offset];
            String filename = Path.Combine(foldername, thisFile);
            filename = Path.Combine(foldername, thisFile) +  ".meta.yaml";

            if (!String.IsNullOrEmpty(textBox1.Text) || !String.IsNullOrEmpty(textBox2.Text))
            {
                List<String> fileContents = new List<string>();
                if (!String.IsNullOrEmpty(textBox1.Text))
                    fileContents.Add("alt_text: " + textBox1.Text);
                if (!String.IsNullOrEmpty(textBox2.Text))
                    fileContents.Add("description: " + textBox2.Text.Replace("\r", "").Replace("\n", "<br>"));
                File.WriteAllLines(filename, fileContents);
            }
            else
            {
                File.Delete(filename);

            }
            change = false;
        }


        private void button4_Click(object sender, EventArgs e)
        {
            syncText();
            offset++;
            if (offset > files.Count()-1)
                offset = files.Count()-1;
            refresh();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ToolTip tt = new ToolTip();
            tt.SetToolTip(textBox1, "The text which will become the Alt_Text tag for the image.");
            tt.SetToolTip(textBox2, "The text which will become the description for the image.");
            tt.SetToolTip(button1, "Select a folder to process (using the existing folder in the folder box as a starting point).");
            tt.SetToolTip(button4, "Next Image (saving changes)");
            tt.SetToolTip(button3, "Prev Image (saving changes)");
            tt.SetToolTip(button5, "Just Save the changes now");
            tt.SetToolTip(button2, "Close the Application (saving changes)");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            syncText();
            offset--;
            if (offset < 0)
                offset = 0;
            refresh();
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            change = true;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            change = true;
        }

        private void label3_Click(object sender, EventArgs e)
        {

        }

        private void button5_Click(object sender, EventArgs e)
        {
            syncText();
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
           
        }

        private void textBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                this.foldername = textBox3.Text;
                openFolder(textBox3.Text);
                if (files.Count() == 0)
                {
                    if (MessageBox.Show("Folder empty. Open folder dialog?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                    {
                        button1_Click(null, null);
                    }
                }
            }
        }

        private void openFolder(String foldername)
        {
            if (!Directory.Exists(foldername))
            {
                MessageBox.Show("Folder " + foldername + " does not exist.");
                return;
            }

            List<String> allfiles = System.IO.Directory.EnumerateFiles(foldername).ToList();
            files = allfiles.Where(a => ((a.Contains(".JPG") || a.Contains(".jpg") ||
                                         a.Contains(".png") || a.Contains(".PNG") ||
                                         a.Contains(".GIF") || a.Contains(".gif")) &&
                                         (!a.Contains(".meta.yaml")))).ToList();

       
            refresh();
            offset = 0;

            textBox3.Text = foldername;
        }
    }
}
